/**
  \mainpage 
  
  \n Copyright (c) 2006 Freescale Semiconductor
  \n Freescale Confidential Proprietary
  
  \brief      Adc Filter driver.
  
  \author     Freescale Semiconductor
  \author     R01160
  \author   	Guadalajara Applications Laboratory RTAC Americas
  
  \version    0.1
  \date       7/2/2008 10:52:40 AM
  
  This driver computes the sample average from any ADC Channel from the MPC5510.
  
  DISCLAIMER: 
  
  *** Services performed by FREESCALE in this matter are performed AS IS and without any warranty. 
  CUSTOMER retains the final decision relative to the total design and functionality of the end product. 
  FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project. 
  FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, implied 
  warranty of merchantability or fitness for a particular purpose on any hardware, software ore advise 
  supplied to the project by FREESCALE, and or any product resulting from FREESCALE services . 
  In no event shall FREESCALE be liable for incidental or consequential damages arising out of this agreement. 
  CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or actions by anyone on account 
  of any damage, or injury, whether commercial, contractual, or tortuous, rising directly or indirectly as a 
  result of the advice or assistance supplied CUSTOMER in connection with product, services or goods supplied
  under this Agreement. ***
*/
#include "Derivative.h"

void TunningFlash(void);

extern IVOR4Handler();
extern uint32_t EXCEPTION_HANDLERS; /* Interrupt Vector Prefix value from link file*/
/* Prototype for PRC1 startup */
extern void __start_p1();


/*--------------------------------------------------------------------------------------*/ 
 /**
 * \brief     Tunes the flash to avoid wait states while reading or accesing flash. 
 * \author    R01160
 * \param     none
 * \return    none
 * \warning   This tunning works only when the MCU runs at 64MHz.
 */  
void TunningFlash(void)
{
  FLASH.PFCRP0.R = 0x04025201;  	
                  /* ||||||||_ PFLIM &  BFEN = 0 
                     |||||||__ DPFEN & IPFEN = 0
                     ||||||___ WWSC = 0b11, RWSC = 0b010
                     |||||____ APC = 0b010
                     ||||_____ M0PFE = 1
                     |||______ 0x00
                     ||_______ ARB = 1
                     |________ LBCG = 0     
                  */
  FLASH.PFCRP1.R = 0x04025201;  	
}

void main (void)
{  
      
   TunningFlash();       /* Tune Flash using a 64MHz reference              */
   vfnInit_PLL();        /* Initialize system bus at 64MHz                  */
 
   CRP.Z0VEC.R = (unsigned long)__start_p1;
   
    for(;;)
    {
   
      //vfnAdc_Sample_Acquire();
      //eqadc_cfifo0_sw_trigger_fnc();
      //vfnWait_Till_Valid_Adc_Result(ADC_FIFO_BUFFER);
      
    }
    
} 

